<?php

/**
 * Product: sonnb - Stop Spam Here
 * Version: 1.2.3
 * Date: 27th Jan 2013
 * Author: sonnb
 * Website: www.sonnb.com - www.UnderWorldVN.com
 * License: You might not copy or redistribute this addon. 
 * ********* Any action to public or redistribute must be authorized from author
 * ********* One copy is valid for one board only*********
 */
class sonnbStopSpamHere_DataWriter_User extends XFCP_sonnbStopSpamHere_DataWriter_User
{    
    protected function _preSave()
    {        
        parent::_preSave();
        
        if (isset($GLOBALS[sonnbStopSpamHere_Global::SONNB_SSH_USER_MODERATE]))
        {
            $this->set('user_state', 'moderated');
        }
        
        if (isset($GLOBALS[sonnbStopSpamHere_Global::SONNB_SSH_USER_DISCOURAGE]))
        {
            $this->set('is_discouraged', 1);
        }
    }
    
    protected function _postSave()
    {
        parent::_postSave();
        
        if (isset($GLOBALS[sonnbStopSpamHere_Global::SONNB_SSH_USER_MODERATE]))
        {
            $this->addLog(
                $GLOBALS[sonnbStopSpamHere_Global::SONNB_SSH_USER_MODERATE]['type'], 
                sonnbStopSpamHere_Model_SSH::ACTION_MODERATE,
                $GLOBALS[sonnbStopSpamHere_Global::SONNB_SSH_USER_MODERATE]['data']
            );
            
            unset($GLOBALS[sonnbStopSpamHere_Global::SONNB_SSH_USER_MODERATE]);
        }
        
        if (isset($GLOBALS[sonnbStopSpamHere_Global::SONNB_SSH_USER_ALLOW]))
        {
            $this->addLog(
                $GLOBALS[sonnbStopSpamHere_Global::SONNB_SSH_USER_ALLOW]['type'], 
                sonnbStopSpamHere_Model_SSH::ACTION_ALLOW,
                $GLOBALS[sonnbStopSpamHere_Global::SONNB_SSH_USER_ALLOW]['data']
            );
            
            unset($GLOBALS[sonnbStopSpamHere_Global::SONNB_SSH_USER_ALLOW]);
        }
        
        if (isset($GLOBALS[sonnbStopSpamHere_Global::SONNB_SSH_USER_DISCOURAGE]))
        {
            $this->addLog(
                $GLOBALS[sonnbStopSpamHere_Global::SONNB_SSH_USER_DISCOURAGE]['type'], 
                sonnbStopSpamHere_Model_SSH::ACTION_DISCOURAGED,
                $GLOBALS[sonnbStopSpamHere_Global::SONNB_SSH_USER_DISCOURAGE]['data']
            );
            
            unset($GLOBALS[sonnbStopSpamHere_Global::SONNB_SSH_USER_DISCOURAGE]);
        }
        
        if (isset($GLOBALS[sonnbStopSpamHere_Global::SONNB_SSH_PERSIONALDETAIL_ALLOW]))
        {
            $this->addLog(
                $GLOBALS[sonnbStopSpamHere_Global::SONNB_SSH_PERSIONALDETAIL_ALLOW]['type'], 
                sonnbStopSpamHere_Model_SSH::ACTION_ALLOW,
                $GLOBALS[sonnbStopSpamHere_Global::SONNB_SSH_PERSIONALDETAIL_ALLOW]['data']
            );
            
            unset($GLOBALS[sonnbStopSpamHere_Global::SONNB_SSH_PERSIONALDETAIL_ALLOW]);
        }
        
        if (isset($GLOBALS[sonnbStopSpamHere_Global::SONNB_SSH_SIGNATURE_ALLOW]))
        {
            $this->addLog(
                $GLOBALS[sonnbStopSpamHere_Global::SONNB_SSH_SIGNATURE_ALLOW]['type'], 
                sonnbStopSpamHere_Model_SSH::ACTION_ALLOW,
                $GLOBALS[sonnbStopSpamHere_Global::SONNB_SSH_SIGNATURE_ALLOW]['data']
            );
            
            unset($GLOBALS[sonnbStopSpamHere_Global::SONNB_SSH_SIGNATURE_ALLOW]);
        }
    }
    
    public function addLog($type, $action, array $data = array())
    {
        $sshModel = new sonnbStopSpamHere_Model_SSH;
        $sshModel->saveLog(
            array(
                'username' => $this->get('username'),
                'email' => $this->get('email'),
                'user_id' => $this->get('user_id'),
                'content_type' => sonnbStopSpamHere_Model_SSH::TYPE_REGISTER,
                'content_id' => $this->get('user_id'),
                'log_type' => $type,
                'data' => serialize($data),
                'action' => $action
            )
        );
    }

}
